# Copyright 2024, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
import numpy as np

# =======================================================================
# VC Judgment and Constant Table (1-500Hz)
VC_JUDGE_TBL = np.array(
    [
        # levelA, B,      C,       D,       E,       F,       G     1/3 oct band center frequency
        [0.406, 0.203, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #   1.00 *
        [0.322, 0.161, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #   1.26
        [0.256, 0.128, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #   1.59
        [0.203, 0.101, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #   2.00 *
        [0.161, 0.081, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #   2.52
        [0.128, 0.064, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #   3.17
        [0.101, 0.051, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #   4.00 *
        [0.081, 0.040, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #   5.04
        [0.064, 0.032, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #   6.35
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #   8.00 *
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #  10.08
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #  12.70
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #  16.00 *
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #  20.16
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #  25.40
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #  32.00 *
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #  40.32
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #  50.80
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #  64.00 *
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], #  80.63
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], # 101.59
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], # 128.00 *
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], # 161.27
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], # 203.19
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], # 256.00 *
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], # 322.54
        [0.050, 0.025, 0.0125, 0.00625, 0.00313, 0.00156, 0.00078], # 406.37
    ]
)

# =======================================================================
# VC Judgement level table
VC_LEVEL_TBL: list[str] = [
    "OA",
    "A",
    "B",
    "C",
    "D",
    "E",
    "F",
    "G",
]
