# Copyright 2024, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

from dataclasses import dataclass, field
from enum import Enum


@dataclass
class MeasureData:
    """Acceleration measurement data => Input data for VcCalculation"""
    index: int = 0
    count: int = 0
    temperature: float = 0
    x: float = 0
    y: float = 0
    z: float = 0
    flag: int = 0

# ====================================================

@dataclass
class VcCalcResult:
    """Output data from VcCalculation"""
    # List of velocities [mm/s] for each 1/3 octave band (composite value of three axes)
    c: list[float] = field(default_factory=list)
    # List of velocities [mm/s] for each 1/3 octave band (X-axis)
    x: list[float] = field(default_factory=list)
    # List of velocities [mm/s] for each 1/3 octave band (Y-axis)
    y: list[float] = field(default_factory=list)
    # List of velocities [mm/s] for each 1/3 octave band (Z-axis)
    z: list[float] = field(default_factory=list)
    # Maximum frequency [Hz] (center frequency of the 1/3 octave band with the maximum velocity)
    max_f: float = 0
    # Maximum velocity [mm/s] (sum of the 1/3 octave band range)
    max_v: float = 0
    # VC judgment result ('OA' to 'G')
    vc_lvl: str = ""
    # Processing execution completion (data update)
    done: bool = False
    # Number of average processing executions (always 0 in single mode)
    avr_num: int = 0

# ====================================================

class OctBand(Enum):
    Oct_1_3 = 1
    Oct_1_6 = 2
    Oct_1_12 = 3

# ====================================================

class DataType(Enum):
    Acceleration = 1    # G
    Velocity = 2        # mm/s

# ====================================================

class VcJudge(Enum):
    Enable = 1
    Disable = 2
