# Copyright 2025, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

"""
VcCalcApp の定数定義

Definition of constants for VcCalcApp
"""

import logger


class ConfigKeys(logger.ConfigKeys):
    """
    VcCalcApp の設定ファイルで使用するキーを定義したクラス
    Class defining keys used in the configuration file for VcCalcApp
    """

    VC_FFT_SIZE = "VC_FFT_SIZE"
    VC_EXE_SIZE = "VC_EXE_SIZE"
    VC_AVG_SIZE = "VC_AVG_SIZE"
    VC_LOG_SINGLE = "VC_LOG_SINGLE"
    VC_LOG_AVERAGE = "VC_LOG_AVERAGE"
    VC_OUTPUT_RAW = "VC_OUTPUT_RAW"
    VC_CONTROL_GPIO = "VC_CONTROL_GPIO"


class Constants(logger.Constants):
    """
    VcCalcApp の定数を定義したクラス

    Class defining constants for VcCalcApp
    """

    A352_SPSS_LIMIT = [1000]

    VC_FFT_SIZE_MIN = 2000
    VC_FFT_SIZE_MAX = 20000
    VC_AVG_SIZE_MIN = 10
    VC_AVG_SIZE_MAX = 50


class InfoKeys(logger.InfoKeys):
    """
    VcCalcApp の計測情報ファイルのキーを定義したクラス

    Class defining keys for the measurement information file of VcCalcApp
    """

    VC_FFT_SIZE = ConfigKeys.VC_FFT_SIZE
    VC_EXE_SIZE = ConfigKeys.VC_EXE_SIZE
    VC_AVG_SIZE = ConfigKeys.VC_AVG_SIZE
    VC_LOG_SINGLE = ConfigKeys.VC_LOG_SINGLE
    VC_LOG_AVERAGE = ConfigKeys.VC_LOG_AVERAGE
    VC_OUTPUT_RAW = ConfigKeys.VC_OUTPUT_RAW
    VC_CONTROL_GPIO = ConfigKeys.VC_CONTROL_GPIO
