# Copyright 2025, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

"""
VcCalcApp のメッセージング実装

Messaging implementation for VcCalcApp
"""

from logger.core import Topic


class VcTopic(Topic):
    """
    VcCalcApp の Topic クラス

    Topic class for VcCalcApp
    """

    @classmethod
    def vc(cls, model: str, serial: str) -> Topic:
        return Topic(f"{cls.sensor(model, serial)}/vc", Topic.Content.SPECIAL)

    @classmethod
    def fft(cls, model: str, serial: str) -> Topic:
        return Topic(f"{cls.sensor(model, serial)}/fft", Topic.Content.SPECIAL)
