# Copyright 2024, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

from logger.core import ConfigOverrideOption, Configurator
from logger.utils.env import init
from tests.fixture.env_path import INVALID_ENV_PATH, VALID_ENV_PATH


class TestConfig:
    class TestGetConfig:
        def test_valid_config_should_return_config_obj(self):
            init(VALID_ENV_PATH)
            conftr = Configurator()
            assert conftr.get_config({}) is not None

        def test_invalid_config_should_return_none(self):
            init(INVALID_ENV_PATH)
            conftr = Configurator()
            assert conftr.get_config({}) is None

        def test_config_file_meas_time_sec_ignored_when_args_supplied(self):
            init(VALID_ENV_PATH)
            # MEASURE_TIME_SEC in the test configuration is 300
            conftr = Configurator()
            config = conftr.get_config({"measure_time_sec": 100})
            assert config is not None
            assert config.measure_time_sec == 100

        def test_option_create_method(self):
            option = ConfigOverrideOption(measure_time_sec=100)
            assert option["measure_time_sec"] == 100

    class TestAddInfo:
        def test_add_part_of_info_keys(self):
            init(VALID_ENV_PATH)
            conftr = Configurator()
            config = conftr.get_config()
            assert config is not None

            info_d: dict = {}
            config.add_info(info_d)

            keys = [
                "FILE_ROTATE_MIN",
                "BAUD_RATE",
                "SENSOR_DATA_DIAG",
                "SENSOR_DATA_DIAG_SEC",
                "MESSAGE_SEND",
                "MESSAGE_HOST",
                "MESSAGE_PORT"
            ]
            assert len(info_d) == 7
            assert list(info_d.keys()) == keys
