# Copyright 2024, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.


class TestDict:
    def test_dict_keep_order(self):
        d1: dict = {"one": 1, "two": 2, "three": 3}

        # キーは登録順
        # Keys are in the order they were added
        assert list(d1.keys()) == ["one", "two", "three"]
        # - この取り出し方でも同様
        # - Same order when retrieved this way
        assert [k for k, _ in d1.items()] == ["one", "two", "three"]

        # 同じキーで順序が違う辞書
        # Dictionary with the same keys but different order
        d2: dict = {"three": 3, "two": 2, "one": 1}
        assert list(d2.keys()) == ["three", "two", "one"]
        assert [k for k, _ in d2.items()] == ["three", "two", "one"]

        # 辞書としては等価
        # Dictionaries are equivalent
        assert d1 == d2

    def test_setvalue_keep_order(self):
        d: dict = {"one": 1, "two": 2, "three": 3}
        assert list(d.keys()) == ["one", "two", "three"]

        # 値を更新する
        # Update a value
        d["two"] = 200

        # キーの順序は変わらず
        # Order of keys remains unchanged
        assert list(d.keys()) == ["one", "two", "three"]

    def test_update_append_key(self):
        d1: dict = {"one": 1, "two": 2, "three": 3}
        d2: dict = {"two": 200, "four": 4, "five": 5}

        d1.update(d2)

        assert list(d1.keys()) == ["one", "two", "three", "four", "five"]
        assert d1 == {"one": 1, "two": 200, "three": 3, "four": 4, "five": 5}
