# Copyright 2025, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

from typing import TypeAlias

SensorKey: TypeAlias = str
"""
センサーのキー項目（logger_id, model, serial）を合成したキーを表す型

Type representing a composite key made from sensor attributes (logger_id, model, serial)
"""


def to_sensor_key(logger_id: str, model: str, serial: str) -> SensorKey:
    """
    Sensor を識別するキーを作成する

    Create a key to identify sensor

    Args:
        logger_id (str): ロガーID
                Logger ID
        model (str): モデル
                Model
        serial (str): シリアル番号
                Serial number

    Returns:
        str: Sensor のキー
                Key for sensor
    """
    return f"{logger_id}#{model}#{serial}"
