# EPSON Bridge Deflection Calculator

## 概要

SEC で作成した橋梁変位推定の Python プログラム

SEC ではこのプログラムを EXE 化して配布しているが、このソース公開版では EXE 化に必要なリソースを削除している

※本プロジェクトでは配布する成果物を「ソフトウェア」と呼ぶ

## 目次

- [ディレクトリ構成](#ディレクトリ構成)
- [主なファイル構成](#主なファイル構成)
- [プロジェクト環境の初期セットアップ](#プロジェクト環境の初期セットアップ)
- [必要パッケージのインストール](#必要パッケージのインストール)
- [プログラムの実行](#プログラムの実行)
- [コードの整形と構文チェック](#コードの整形と構文チェック)
- [リンク集](#リンク集)

## ディレクトリ構成

```txt
.
├── README.md
├── pyproject.toml
└── src
    └── epson_bdc
        ├── doc
        │   ├── word_table.csv
        │   ├── EULA_JP.txt
        │   ├── EULA_EN.txt
        │   ├── Epson_Bridge_Deflection_Calculator_UserGuide_JP_rev20250325.pdf
        │   └── Epson_Bridge_Deflection_Calculator_UserGuide_EN_rev20250325.pdf
        ├── img
        │   ├── epson_logo.png
        │   └── icon.ico
        ├── data
        │   └── sample.csv
        ├── __init__.py
        ├── constants.py
        ├── main_jp.py
        ├── main_en.py
        ├── main.py
        └── bdc_core.py
```

- src: pythonのソースコードを置くフォルダ
  - epson_bdc: 作成コードを `epson_bdc` というモジュールで一元管理するため一階層分フォルダを切っている
    - doc: EULAの文言、日英対応表などドキュメントを置くフォルダ
    - img: ロゴファイルなど画像を置くフォルダ
    - data: サンプルデータなどソフトウェアに関するデータファイルを置くフォルダ

## 主なファイル構成

- `constants.py`
  - ソフトウェア内で使用する定数を定義してあるファイル
- `bdc_core.py`
  - ソフトウェアのメインロジックの処理を記載したファイル
- `main.py`
  - ロガーの設定・日英対応表からの文言取得を行う
  - 処理としては `bdc_core.py` を呼び出すのみ
- `main_jp.py`
  - ソフトウェアを日本語版で実行するためのファイル
  - `main.py` が日英対応表から日本語の文言を取得するよう指定して実行する
- `main_en.py`
  - ソフトウェアを英語版で実行するためのファイル
  - `main.py` が日英対応表から英語の文言を取得するよう指定して実行する

## プロジェクト環境の初期セットアップ

記載しているコマンドはすべて作業フォルダ直下からの実行を想定している

### For Mac and Linux

- python のバージョン管理は[pyenv](https://github.com/pyenv/pyenv) を用いる
- 仮想環境の作成

```sh
python -m venv .venv
source .venv/bin/activate
```

### For Windows

- python のバージョン管理は py コマンドを通じて行う
- 仮想環境の作成時にバージョンを指定する

```sh
py -3.12 -m venv .venv
.venv\scripts\activate.ps1
```

## 必要パッケージのインストール

記載しているコマンドはすべて作業フォルダ直下からの実行を想定している

### For Mac and Linux

- pyproject.toml に必要なパッケージを記載してある
  - ソフトウェアの機能以外のフォーマット等に必要なライブラリも記載済み

```sh
pip install -e .
pip install -e ."[dev]"
```

### For Windows

- pyproject.toml に必要なパッケージを記載してある
  - ソフトウェアの機能以外のフォーマット等に必要なライブラリも記載済み

```sh
pip install -e .
pip install -e .[dev]
```

## プログラムの実行

記載しているコマンドはすべて作業フォルダ直下からの実行を想定している

### 日本語版の実行

以下を実行する

```sh
python src/epson_bdc/main_jp.py
```

### 英語版の実行

以下を実行する

```sh
python src/epson_bdc/main_en.py
```

## コードの整形と構文チェック

記載しているコマンドはすべて作業フォルダ直下からの実行を想定している

```sh
black .  # コードの整形
ruff check src  # 構文チェック
mypy --check-untyped-defs src  # 型チェック
```

## リンク集

### 使用ライブラリの公式ドキュメント

- [numpy](https://numpy.org/doc/1.26/)
- [pandas](https://pandas.pydata.org/pandas-docs/version/2.2/index.html)
- [matplotlib](https://matplotlib.org/3.9.0/index.html)
