# Copyright 2024, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.


class TerminateException(Exception):
    """
    OS からシグナルを受信したことを通知する例外クラス
    - SIGTERM や SIGINT を受信し、その処理を例外機構に委ねる場合に使用する

    Exception class to notify that a signal has been received from the OS
      Used when SIGTERM or SIGINT is received and the handling is delegated to the exception mechanism
    """

    pass


def raise_terminate_exception(*_):
    """
    シグナルを受信後、例外を発生させるハンドラ

    Handler that raises an exception after receiving a signal

    Raises:
        TerminateException: シグナルによって例外が上がったことを表すエラー
            Error indicating that an exception has been raised by a signal
    """
    raise TerminateException


class LoggerError(Exception):
    """
    ロガープログラムから発生させる一般的な例外

    General exception raised by the logger program
    """

    pass
