# Copyright 2024, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.


from logger.core.message import MessageService, Topic

# Setup dummy values
Topic._root_elem = "logger"
Topic._logger_id = "LG1"


class TestTopic:
    def test_logger(self):
        topic = Topic.logger()
        assert topic.topic == "logger/LG1"
        assert topic.content == Topic.Content.STATUS

    def test_logger_error(self):
        topic = Topic.logger_error()
        assert topic.topic == "logger/LG1/error"
        assert topic.content == Topic.Content.ERROR

    def test_sensor(self):
        topic = Topic.sensor("A123", "0123")
        assert topic.topic == "logger/LG1/sensor/A123/0123"
        assert topic.content == Topic.Content.STATUS

    def test_sensor_error(self):
        topic = Topic.sensor_error("A123", "0123")
        assert topic.topic == "logger/LG1/sensor/A123/0123/error"
        assert topic.content == Topic.Content.ERROR

    def test_sensor_lost(self):
        topic = Topic.sensor_lost("A123", "0123")
        assert topic.topic == "logger/LG1/sensor/A123/0123/lost"
        assert topic.content == Topic.Content.MESSAGE

    def test_sensor_abnormal(self):
        topic = Topic.sensor_abnormal("A123", "0123")
        assert topic.topic == "logger/LG1/sensor/A123/0123/abnormal"
        assert topic.content == Topic.Content.MESSAGE

    def test_equals(self):
        topic1 = Topic.logger()
        topic2 = Topic.logger()
        assert topic1 == topic2

class TestErrorLevel:
    def test_name(self):
        assert MessageService.ErrorLevel.WARNING.name == "WARNING"
