# Copyright 2024, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

from logger.utils.env import (
    get_bool,
    get_float,
    get_int,
    get_str,
    init,
    parse_bool,
    parse_float,
    parse_int,
)
from tests.fixture.env_path import TEST_ENV_PATH


class TestEnv:
    class TestParseInt:
        def test_parse_string_one_should_return_1(self):
            assert parse_int("1") == 1

        def test_parse_non_number_string_should_return_none(self):
            assert parse_int("hoge") is None

    class TestParseFloat:
        def test_parse_string_float_value_should_return_float(self):
            assert parse_float("1.23") == 1.23

        def test_parse_string_int_value_should_return_float(self):
            assert parse_float("3") == 3.0

        def test_parse_non_number_string_should_return_none(self):
            assert parse_float("hoge") is None

    class TestParseBool:
        def test_parse_string_true_should_return_True(self):
            assert parse_bool("True")

        def test_parse_non_bool_string_should_return_none(self):
            assert parse_bool("hoge") is None

    class TestGetStr:
        def test_get_exist_key_should_return_string(self):
            init(TEST_ENV_PATH)
            assert get_str("STRING") == "hoge"

        def test_get_non_exist_key_should_return_none(self):
            init(TEST_ENV_PATH)
            assert get_str("NON_EXIST_KEY") is None

    class TestGetInt:
        def test_get_exist_valid_value_key_should_return_int(self):
            init(TEST_ENV_PATH)
            assert get_int("NUMBER") == 123

        def test_get_exist_invalid_value_key_should_return_none(self):
            init(TEST_ENV_PATH)
            assert get_int("WRONG_NUMBER") is None

        def test_get_non_exist_key_should_return_none(self):
            init(TEST_ENV_PATH)
            assert get_int("NON_EXIST_KEY") is None

    class TestGetFloat:
        def test_get_exist_valid_value_key_should_return_float(self):
            init(TEST_ENV_PATH)
            assert get_float("FLOAT") == 1.23

        def test_get_exist_invalid_value_key_should_return_none(self):
            init(TEST_ENV_PATH)
            assert get_float("WRONG_FLOAT") is None

        def test_get_non_exist_key_should_return_none(self):
            init(TEST_ENV_PATH)
            assert get_float("NON_EXIST_KEY") is None

    class TestGetBool:
        def test_get_exist_valid_value_key_should_return_(self):
            init(TEST_ENV_PATH)
            assert not get_bool("BOOL")

        def test_get_exist_invalid_value_key_should_return_none(self):
            init(TEST_ENV_PATH)
            assert get_bool("WRONG_BOOL") is None

        def test_get_non_exist_key_should_return_none(self):
            init(TEST_ENV_PATH)
            assert get_bool("NON_EXIST_KEY") is None
