# Copyright 2024, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

import pytest

from logger.utils.lock import ExclusiveLock, LockError


class TestExclusionControl:
    class TestAcquire:
        def test_acquire_should_not_raise_error(self, tmpdir):
            lockfile = f"{tmpdir}/lock.lock"
            lock = ExclusiveLock(lockfile)

            try:
                lock.acquire()
            except Exception:
                pytest.fail("ExclusionControl acquire raise unknown error")

        @pytest.mark.skip(reason="テスト環境でのみ二回目のロックが獲得できない")
        # @pytest.mark.skip(reason="Cannot acquire the lock a second time in the test environment")
        def test_acquire_should_raise_error_when_already_locked(self, tmpdir):
            lockfile = f"{tmpdir}/lock.lock"
            lock = ExclusiveLock(lockfile)

            try:
                lock.acquire()
            except Exception:
                pytest.fail("ExclusionControl acquire raise unknown error")

            # なぜかエラーが上がらない
            # For some reason, no error is raised
            with pytest.raises(LockError):
                lock.acquire()

            # こっちはエラーがあがる。。。
            # This one raises an error...
            # with open(lockfile, "w") as f:
            #     fcntl.flock(f.fileno(), fcntl.LOCK_EX | fcntl.LOCK_NB)

        def test_acquire_should_success_after_release(self, tmpdir):
            lockfile = f"{tmpdir}/lock.lock"
            lock = ExclusiveLock(lockfile)
            lock.release()

            try:
                lock.acquire()
            except Exception:
                pytest.fail("ExclusionControl acquire raise unknown error")

    class TestRelease:
        def test_release_should_success_call_twice(self, tmpdir):
            lockfile = f"{tmpdir}/lock.lock"
            lock = ExclusiveLock(lockfile)
            lock.release()

            try:
                lock.release()
            except Exception:
                pytest.fail("ExclusionControl release raise unknown error")
