# Copyright 2025, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

from raspi_web.data.vc_data import FFTData, VCData, VCLevel, VCLevelType
from tests.testutils.data_sample import get_fft_data_sample


class TestVCData:
    def test_is_empty(self):
        vc_data = VCData()
        expect = True

        actual = vc_data.is_empty()

        assert expect == actual

    def test_is_empty_exist_vc_level(self):
        vc_level = VCLevel(timestamp="2000/11/11 11:11:11", level="A")
        vc_data = VCData(vc_level=vc_level)

        expect = False

        actual = vc_data.is_empty()

        assert expect == actual

    def test_is_empty_exist_fft(self):
        value = get_fft_data_sample()
        fft_data = FFTData(timestamp="2000/11/11 11:11:11", value=value)
        vc_data = VCData(fft_data=fft_data)

        expect = False

        actual = vc_data.is_empty()

        assert expect == actual

    def test_update_level(self):

        vc_level = VCLevel(timestamp="2000/11/11 11:11:11", level="A")
        vc_data = VCData(vc_level=vc_level)

        expect: VCLevelType = "G"
        update_info = VCLevel(timestamp="2000/11/11 11:11:11", level=expect)

        vc_data.update_vc_level(vc_level=update_info)

        assert vc_data.vc_level is not None
        assert expect == vc_data.vc_level.level

    def test_update_level_to_none(self):
        vc_level = VCLevel(timestamp="2000/11/11 11:11:11", level="A")
        vc_data = VCData(vc_level=vc_level)
        update_info = None

        vc_data.update_vc_level(vc_level=update_info)

        assert vc_data.vc_level is None

    def test_update_fft_data(self):

        fft_data = FFTData(timestamp="2000/11/11 11:11:11", value=get_fft_data_sample())
        vc_data = VCData(fft_data=fft_data)

        expect = list[float](range(27))
        update_info = FFTData(timestamp="2000/11/11 11:11:11", value=expect)

        vc_data.update_fft_data(fft_data=update_info)

        assert vc_data.fft_data is not None
        assert expect == vc_data.fft_data.value

    def test_update_fft_data_to_none(self):
        fft_data = FFTData(timestamp="2000/11/11 11:11:11", value=get_fft_data_sample())
        vc_data = VCData(fft_data=fft_data)
        update_info = None

        vc_data.update_fft_data(fft_data=update_info)

        assert vc_data.fft_data is None
