# Copyright 2025, Seiko Epson Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the “Software”), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
# Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.


class Const:
    """
    システムで使用する定数を定義したクラス

    Class defining constants used in this system
    """

    TOPIC_DATA = "summary/{logger_id}/{model}/{serial}/data"
    TOPIC_ALERT = "summary/{logger_id}/{model}/{serial}/alert"

    AXIS_VALUES = ["X", "Y", "Z", "C"]
    """
    軸のパターンを保持するリスト、便宜上 C を含む

    List of axis patterns, including C for convenience
    """

    LOG_LEVELS = ["DEBUG", "INFO", "WARN", "ERROR"]
    LOG_LEVEL_DEFAULT = LOG_LEVELS[1]


class ConfigKey:
    """
    設定ファイルで使用するキー項目を定義したクラス

    Class defining key items used in the configuration file
    """

    LOGGER_ID = "LOGGER_ID"
    OUTPUT_PATH = "OUTPUT_PATH"

    MESSAGE_HOST = "MESSAGE_HOST"
    MESSAGE_PORT = "MESSAGE_PORT"
    MESSAGE_CLID = "MESSAGE_CLID"

    LOG_LEVEL = "LOG_LEVEL"

    SENSOR_MODEL = "SENSOR_MODEL"
    MAX_MEASUREMENTS = "MAX_MEASUREMENTS"

    SKIP_SECONDS = "SKIP_SECONDS"
    SUMMARY_SECONDS = "SUMMARY_SECONDS"

    PTN_TREND_BASE = "{model}_{serial}_{axis}_TREND_BASE"
    PTN_TREND_ALRM = "{model}_{serial}_{axis}_TREND_ALARM"
    PTN_TREND_TRIP = "{model}_{serial}_{axis}_TREND_TRIP"

    PTN_CHANGE_ALRM = "{model}_{serial}_{axis}_CHANGE_ALARM"
    PTN_CHANGE_TRIP = "{model}_{serial}_{axis}_CHANGE_TRIP"


class ExitCode:
    """
    システムの終了コードを定義したクラス

    Class defining system exit codes
    """

    EX_OK: int = 0
    EX_NG: int = 1
